IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CP_SCA_RegistrarAcceso]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE [dbo].[CP_SCA_RegistrarAcceso] 
END
GO

CREATE PROCEDURE [dbo].[CP_SCA_RegistrarAcceso]	@pId_Controlador		SMALLINT,
												@pTipoAcceso			CHAR(1),		/*E: Entrada / S:Salida*/
												@pFecha					DATETIME,		/*Fecha a comparar*/
												@pFechaEvento			DATETIME,		/*Fecha del Evento a comparar. Si no es un evento ingresar 19000101*/
												@pTag					VARCHAR(MAX),	/*Credencial MiFare / Wiegand*/
												@pDoc					BIGINT,			/*Documento*/
												@pHue					VARCHAR(5000),	/*Huella Dactilar*/
												@pCba					VARCHAR(20),	/*Codigo de Barra*/
												@pDma					VARCHAR(5000),	/*Data Matrix*/
												@pFlag_GrabaRegistro	TINYINT = NULL, /*23/09/2019. 1(default): Graba Registro. 0: No graba el registro*/
												@pFlag_Permite_Paso		TINYINT = NULL,	/*05/02/2020. 1: Si el resultado es habilitado permite que la persona pase 1 vez mas la proxima vez*/
												@pFlag_Generacion_LB	TINYINT = NULL	/*02/11/2020. 1: Si la llamada la esta haciendo para generar Listas Blancas, en esos casos hay validaciones que no hace como Validacion de Turnos*/
AS

BEGIN

/*Variables Locales*/
DECLARE @Id_Cliente							INT
DECLARE @Id_Cliente_Ref						INT
DECLARE @Huella								VARBINARY
DECLARE @Tipo_Validacion					CHAR(1)
DECLARE @Activo								TINYINT
DECLARE @Foto								VARCHAR(254)
DECLARE @Foto_Bin							VARBINARY(MAX)
DECLARE @Ult_Foto_Bin						TINYINT
DECLARE @ValidarAcceso						TINYINT
DECLARE @ValidarPersona						TINYINT
DECLARE @ValidoTagsImportados				TINYINT
DECLARE @ValidarContratosTiposRechazos		INT
DECLARE @Flag_ValidarMaster					TINYINT
DECLARE @ValidarContratosTipos				INT
DECLARE @ContratoRechazo_Descripcion		VARCHAR(500)
DECLARE @ContratoHabilitado_Descripcion		VARCHAR(500)
DECLARE @ValidarTipo						SMALLINT
DECLARE @Clientes_Tipos_Habil_Descripcion	VARCHAR(5000)
DECLARE @ValidarTipoRechazo					SMALLINT
DECLARE @Clientes_Tipos_Rechazo_Descripcion	VARCHAR(500)
DECLARE @ValidarProdVta						VARCHAR(14)
DECLARE @Producto_Descripcion_Resumida		VARCHAR(100)
DECLARE @ValidarEvento						SMALLINT
DECLARE @Clientes_Tipos_Habil_Evento		VARCHAR(5000)
DECLARE @Flag_Antipassback					CHAR(1)
DECLARE @Flag_ValidarUCP					TINYINT
DECLARE @ValidarVencimientosPersona			VARCHAR(10)
DECLARE @VencimientoPersona_Descripcion		VARCHAR(50)
DECLARE @pId_Acceso							SMALLINT
DECLARE @Flag_Foto_Validar					TINYINT		/*14/03/2019 Validacion Agregada*/
DECLARE @Flag_Turno_Validar					TINYINT		/*10/08/2020 Validacion Agregada*/
DECLARE @Id_CD_Motivo						INT
DECLARE @AccesoPermitidoManualmente			TINYINT		/*05/02/2020 Agregado*/
DECLARE @Flag_Clientes_Link_Validar			TINYINT		/*28/09/2020 Validacion agregada por QR impresos*/
DECLARE @ValidoCleverQR						INT			/*21/10/2020 Validacion agregada de rechazo por CleverQR*/
DECLARE @Tipo_Cont							CHAR(1)
DECLARE @Flag_Evento						TINYINT
/*FIN Variables Locales*/
						
PRINT 'INCIO del Proceso: CP_SCA_RegistrarAcceso'

SELECT 
@Tipo_Cont = ISNULL(Tipo_Cont, '')
FROM CD_Controladores
WHERE
Id_Controlador = @pId_Controlador
PRINT '@Tipo_Cont: ' + @Tipo_Cont

SET @pId_Acceso = (dbo.CF_SCA_IdAcceso(@pId_Controlador))

PRINT 'Id_Acceso: ' + CONVERT(VARCHAR(10), @pId_Acceso) + ' Fecha: ' + CONVERT(VARCHAR(10), @pFecha, 103)
PRINT '@pTipoAcceso: ' + CONVERT(VARCHAR(10), @pTipoAcceso)
PRINT '@pTag: ' + @pTag
PRINT '@pDoc: ' + CONVERT(VARCHAR(10), @pDoc)
PRINT '@pHue: ' + @pHue
PRINT '@pCba: ' + @pCba
PRINT '@pDma: ' + @pDma

IF(@pFlag_GrabaRegistro IS NULL)
BEGIN
	SET @pFlag_GrabaRegistro = 1
END
PRINT '@pFlag_GrabaRegistro: ' + CONVERT(VARCHAR(10), @pFlag_GrabaRegistro)

IF(@pFlag_Permite_Paso IS NULL)
BEGIN
	SET @pFlag_Permite_Paso = 0
END
PRINT '@pFlag_Permite_Paso: ' + CONVERT(VARCHAR(10), @pFlag_Permite_Paso)

IF(@pFlag_Generacion_LB IS NULL)
BEGIN
	SET @pFlag_Generacion_LB = 0
END
PRINT '@pFlag_Generacion_LB: ' + CONVERT(VARCHAR(10), @pFlag_Generacion_LB)

SET @Huella	= CONVERT(VARBINARY, @pHue)

SET @Tipo_Validacion = dbo.CF_SCA_TipoValidacion(@pTag, @pDoc, @pHue, @pCba, @pDma)

PRINT 'Tipo de Validacion: ' + @Tipo_Validacion

IF(@Tipo_Validacion = 'N')
BEGIN
	SET @Id_CD_Motivo = 101 /*No se enviaron datos de validacion*/
    EXEC CP_SCA_RegistrarAcceso_Rta 0, '', 'ERROR', '', 0, 0, 0, @pTipoAcceso, @pTag, @pFecha, @pId_Controlador, @pId_Acceso, @Id_CD_Motivo, @pFlag_GrabaRegistro, @pFlag_Permite_Paso
	RETURN
END

/*A partir de aca existe una variable de validacion*/

/*-----------------------------------------------------------------------------------Valido si existe el Acceso*/
SET @ValidarAcceso = (dbo.CF_SCA_ValidoAcceso(@pId_Acceso))
PRINT 'Acceso Valido: ' + CONVERT(VARCHAR(10), @ValidarAcceso)

IF(@ValidarAcceso = 0)
BEGIN
	SET @Id_CD_Motivo = 102 /*El Acceso no existe*/
	EXEC CP_SCA_RegistrarAcceso_Rta 0, '', 'ERROR', '', 0, 0, 0, @pTipoAcceso, @pTag, @pFecha, @pId_Controlador, @pId_Acceso, @Id_CD_Motivo, @pFlag_GrabaRegistro, @pFlag_Permite_Paso
	RETURN
END
/*-----------------------------------------------------------------------------------FIN Valido si existe el Acceso*/


/*06/10/2021 Se agrega para Extraer Dato Flag_Evento y determinar que validaciones se hacen y cuales no dependiendo si es un evento*/
SELECT
@Flag_Evento = ISNULL(Flag_Evento, 0)
FROM CD_Accesos
WHERE
Id_Acceso = @pId_Acceso
/*FIN 06/10/2021*/


/*-----------------------------------------------------------------------------------Valido Tags Importados*/
IF(@Flag_Evento IN (1))
BEGIN
	EXEC dbo.CP_SCA_ValidoTagsImportados @pTag, 1 , @Flag_TagHabilitado = @ValidoTagsImportados OUTPUT

	PRINT 'Valido Tags Importados: ' + CONVERT(VARCHAR(10), ISNULL(@ValidoTagsImportados, 0))

	IF(ISNULL(@ValidoTagsImportados, 0) = 1)
	BEGIN
		SET @Id_CD_Motivo = 201 /*Ingreso por Ticket Import.*/
		EXEC CP_SCA_RegistrarAcceso_Rta 1, '', 'ADVER', '', 0, 0, 0, @pTipoAcceso, @pTag, @pFecha, @pId_Controlador, @pId_Acceso, @Id_CD_Motivo, @pFlag_GrabaRegistro, @pFlag_Permite_Paso
		RETURN
	END
END
/*-----------------------------------------------------------------------------------FIN Valido Tags Importados*/


/*-----------------------------------------------------------------------------------Valido si lo que recibio es un CleverQR*/
IF(@Flag_Evento IN (0,1))
BEGIN
	IF(@pDma <> '')
	BEGIN
		EXEC dbo.CP_SCA_ValidoCleverQR @pDma, @pId_Acceso, @pFecha, @Flag_QRValido = @ValidoCleverQR OUTPUT
		PRINT 'Valido CleverQR: ' + CONVERT(VARCHAR(10), @ValidoCleverQR)
	
		IF(@ValidoCleverQR = 0)
		BEGIN
			SET @Id_CD_Motivo = 114 /*QR Invalido*/
			EXEC CP_SCA_RegistrarAcceso_Rta 1, '', 'ADVER', '', 0, 0, 0, @pTipoAcceso, @pTag, @pFecha, @pId_Controlador, @pId_Acceso, @Id_CD_Motivo, @pFlag_GrabaRegistro, @pFlag_Permite_Paso
			RETURN
		END
	
		IF(@ValidoCleverQR = -1)
		BEGIN
			SET @Id_CD_Motivo = 115 /*QR Vencido*/
			EXEC CP_SCA_RegistrarAcceso_Rta 1, '', 'ADVER', '', 0, 0, 0, @pTipoAcceso, @pTag, @pFecha, @pId_Controlador, @pId_Acceso, @Id_CD_Motivo, @pFlag_GrabaRegistro, @pFlag_Permite_Paso
			RETURN
		END
	
		IF(@ValidoCleverQR = -2)
		BEGIN
			SET @Id_CD_Motivo = 116 /*QR ya utilizado*/
			EXEC CP_SCA_RegistrarAcceso_Rta 1, '', 'ADVER', '', 0, 0, 0, @pTipoAcceso, @pTag, @pFecha, @pId_Controlador, @pId_Acceso, @Id_CD_Motivo, @pFlag_GrabaRegistro, @pFlag_Permite_Paso
			RETURN
		END
	END
END
/*-----------------------------------------------------------------------------------FIN Valido si lo que recibio es un CleverQR*/


/*-----------------------------------------------------------------------------------IDENTIFICACION DEL CLIENTE*/
SET @Id_Cliente = (SELECT dbo.CF_SCA_IdentifIdCliente(@pTag))

PRINT '@Id_Cliente: ' + CONVERT(VARCHAR(10), @Id_Cliente)
/*-----------------------------------------------------------------------------------FIN IDENTIFICACION DEL CLIENTE*/


/*-----------------------------------------------------------------------------------Acceso Permitido Manualmente. Agregado 05/02/2020*/
IF(@Flag_Evento IN (0))
BEGIN
	EXEC dbo.CP_SCA_ValidoAccesoPermitidoManualmente @Id_Cliente, @pFecha, @pId_Controlador, @Flag_AccesoPermitidoManualmente = @AccesoPermitidoManualmente OUTPUT

	PRINT 'Acceso permitido manualmente: ' + CONVERT(VARCHAR(10), ISNULL(@AccesoPermitidoManualmente, 0))

	IF(ISNULL(@AccesoPermitidoManualmente, 0) = 1)
	BEGIN
		SET @Id_CD_Motivo = 211 /*Ingreso por Habilt. Manualmente.*/
		EXEC CP_SCA_RegistrarAcceso_Rta 1, '', 'ADVER', '', 0, 0, 0, @pTipoAcceso, @pTag, @pFecha, @pId_Controlador, @pId_Acceso, @Id_CD_Motivo, @pFlag_GrabaRegistro, @pFlag_Permite_Paso
		RETURN
	END
END
/*-----------------------------------------------------------------------------------FIN Acceso Permitido Manualmente*/


/*-----------------------------------------------------------------------------------Valido Persona*/
IF(@Flag_Evento IN (0,1))
BEGIN
	SET @ValidarPersona = (dbo.CF_SCA_ValidarPersona(@Id_Cliente))
	PRINT 'Persona Valida: ' + CONVERT(VARCHAR(10), @ValidarPersona)

	IF(@ValidarPersona = 0)
	BEGIN
		SET @Id_CD_Motivo = 103 /*La Persona es invalida*/
		EXEC CP_SCA_RegistrarAcceso_Rta 0, '', 'ERROR', '', 0, 0, 0, @pTipoAcceso, @pTag, @pFecha, @pId_Controlador, @pId_Acceso, @Id_CD_Motivo, @pFlag_GrabaRegistro, @pFlag_Permite_Paso
		RETURN
	END
END
/*-----------------------------------------------------------------------------------FIN Valido Persona*/


/*-----------------------------------------------------------------------------------Datos Persona*/
SELECT 
@Activo			= ISNULL(Activo, 0),
@Foto			= ISNULL(Foto, ''),
@Id_Cliente_Ref	= ISNULL(Id_Cliente_Ref, 0)
FROM Clientes 
WHERE 
Id_Cliente = @Id_Cliente

PRINT 'Persona Activa: ' + CONVERT(VARCHAR(10), @Activo)
PRINT 'Persona Foto: ' + @Foto
PRINT 'Id_Cliente Titular: ' + CONVERT(VARCHAR(10), @Id_Cliente_Ref)

SET @Ult_Foto_Bin = ISNULL((SELECT MIN(Nro) FROM Clientes_Fotos WHERE Id_Cliente = @Id_Cliente), 0) ---siempre tomamos la 1

IF(@Ult_Foto_Bin <> 0)
BEGIN
	IF(dbo.CF_xParam('SCA_RtaCtrl_Foto') = 1 AND @Tipo_Cont <> 'K'/*Molinete Intelektron*/)
	BEGIN
		SET @Foto_Bin = (SELECT Foto FROM Clientes_Fotos CF WHERE Id_Cliente = @Id_Cliente AND Nro = @Ult_Foto_Bin)		
	END
		
	PRINT 'Persona Foto_Bin: ' + CONVERT(VARCHAR(MAX), @Foto_Bin)
END
/*-----------------------------------------------------------------------------------FIN Datos Persona*/


/*-----------------------------------------------------------------------------------Valido Persona Activa*/
IF(@Flag_Evento IN (0,1))
BEGIN
	IF(@Activo = 0)
	BEGIN
		SET @Id_CD_Motivo = 104 /*La Persona esta desactivada*/
		EXEC CP_SCA_RegistrarAcceso_Rta 0, '', 'ADVER', @Foto, @Foto_Bin, @Id_Cliente, @Id_Cliente_Ref, @pTipoAcceso, @pTag, @pFecha, @pId_Controlador, @pId_Acceso, @Id_CD_Motivo, @pFlag_GrabaRegistro, @pFlag_Permite_Paso
		RETURN
	END
END
/*-----------------------------------------------------------------------------------FIN Valido Persona Activa*/


/*-----------------------------------------------------------------------------------Valido Vencimientos*/
IF(@Flag_Evento IN (0))
BEGIN
	SET @ValidarVencimientosPersona = (dbo.CF_SCA_ValidarVencimientosPersona(@Id_Cliente, @pId_Acceso, @pFecha))
	PRINT 'Valida Vencimientos: ' + CONVERT(VARCHAR(10), @ValidarVencimientosPersona)

	IF(@ValidarVencimientosPersona <> '')
	BEGIN
		SET @Id_CD_Motivo = 105 /*Rechazo por Tipo de Venc.*/
		SET @VencimientoPersona_Descripcion = (SELECT SUBSTRING(RTRIM(LTRIM(Descripcion)), 1, 16) FROM Clientes_Venc_Tipos WHERE Id_Tipo_Venc = @ValidarVencimientosPersona) + ' vencido el: ' + (SELECT CONVERT(VARCHAR(10), CV.Fecha, 105) FROM Clientes_Venc CV WHERE CV.Id_Cliente = @Id_Cliente AND CV.Id_Tipo_Venc = @ValidarVencimientosPersona )
		PRINT 'Tipo de Vencimiento de Rechazo: ' + @VencimientoPersona_Descripcion
	
		EXEC CP_SCA_RegistrarAcceso_Rta 0, @VencimientoPersona_Descripcion, 'ADVER', @Foto, @Foto_Bin, @Id_Cliente, @Id_Cliente_Ref, @pTipoAcceso, @pTag, @pFecha, @pId_Controlador, @pId_Acceso, @Id_CD_Motivo, @pFlag_GrabaRegistro, @pFlag_Permite_Paso
		RETURN
	END
END
/*-------------------------------------------------------------------------------FIN Valido Vencimientos*/


/*-----------------------------------------------------------------------------------Valido Contratos Tipos de Rechazo*/
IF(@Flag_Evento IN (0))
BEGIN
	SET @ValidarContratosTiposRechazos = (dbo.CF_SCA_ValidarContratosTiposRechazos(@Id_Cliente, @pId_Acceso, @pFecha))
	PRINT 'Valida Contratos Tipos Rechazos: ' + CONVERT(VARCHAR(10), @ValidarContratosTiposRechazos)

	IF(@ValidarContratosTiposRechazos <> 0)
	BEGIN
		SET @Id_CD_Motivo = 106 /*Rechazo por Tipo de Contrato*/
		SET @ContratoRechazo_Descripcion = (SELECT RTRIM(LTRIM(CT.Descripcion)) FROM Contratos_Tipos CT, Contratos CO WHERE CT.Id_Tipo_Con = CO.Id_Tipo_Con AND Id_Contrato = @ValidarContratosTiposRechazos)
		PRINT 'Tipo de Contrato de Rechazo: ' + @ContratoRechazo_Descripcion

		EXEC CP_SCA_RegistrarAcceso_Rta 0, @ContratoRechazo_Descripcion, 'ADVER', @Foto, @Foto_Bin, @Id_Cliente, @Id_Cliente_Ref, @pTipoAcceso, @pTag, @pFecha, @pId_Controlador, @pId_Acceso, @Id_CD_Motivo, @pFlag_GrabaRegistro, @pFlag_Permite_Paso
		RETURN
	END
END
/*-----------------------------------------------------------------------------------FIN Valido Contratos Tipos de Rechazo*/


/*-----------------------------------------------------------------------------------Valida Tipo de Categoria de Rechazo*/
IF(@Flag_Evento IN (0))
BEGIN
	SET @ValidarTipoRechazo = (dbo.CF_SCA_ValidarTipoRechazos(@Id_Cliente, @pId_Acceso, @pFecha))
	PRINT 'Tipo de Cliente de Rechazo: ' + CONVERT(VARCHAR(10), @ValidarTipoRechazo)

	IF(@ValidarTipoRechazo <> 0)
	BEGIN
		SET @Id_CD_Motivo = 107 /*Rechazo por Categoria*/
	
		SET @Clientes_Tipos_Rechazo_Descripcion = (SELECT RTRIM(LTRIM(CT.Descripcion)) FROM Clientes_Tipos CT WHERE Id_Tipo_Cli = @ValidarTipo)
		PRINT 'Tipo de Cliente de Rechazo: ' + @Clientes_Tipos_Rechazo_Descripcion
	
		EXEC CP_SCA_RegistrarAcceso_Rta 0, @Clientes_Tipos_Rechazo_Descripcion, 'OBSER', @Foto, @Foto_Bin, @Id_Cliente, @Id_Cliente_Ref, @pTipoAcceso, @pTag, @pFecha, @pId_Controlador, @pId_Acceso, @Id_CD_Motivo, @pFlag_GrabaRegistro, @pFlag_Permite_Paso
		RETURN
	END
END
/*-----------------------------------------------------------------------------------FIN Valida Tipo de Categoria de Rechazo*/


/*-----------------------------------------------------------------------------------Valida Persona Master*/
IF(@Flag_Evento IN (0,1))
BEGIN
	SET @Flag_ValidarMaster = (dbo.CF_SCA_ValidarMaster(@Id_Cliente))
	PRINT 'Valida Persona Master: ' + CONVERT(VARCHAR(10), @Flag_ValidarMaster)

	IF(@Flag_ValidarMaster = 1)
	BEGIN
		SET @Id_CD_Motivo = 202 /*Acceso Master*/
	
		EXEC CP_SCA_RegistrarAcceso_Rta 1, '', 'OBSER', @Foto, @Foto_Bin, @Id_Cliente, @Id_Cliente_Ref, @pTipoAcceso, @pTag, @pFecha, @pId_Controlador, @pId_Acceso, @Id_CD_Motivo, @pFlag_GrabaRegistro, @pFlag_Permite_Paso
		RETURN
	END
END
/*-----------------------------------------------------------------------------------FIN Valida Persona Master*/


/*-----------------------------------------------------------------------------------Valida AntiPassBack*/
IF(@Flag_Evento IN (0,1))
BEGIN
	SET @Flag_Antipassback = (dbo.CF_SCA_Antipassback(@Id_Cliente, @pId_Acceso, @pFecha, @pTipoAcceso, @pFechaEvento))
	PRINT 'Flag Antipassback: ' + @Flag_Antipassback
	IF(@Flag_Antipassback <> 'O')
	BEGIN
		IF(@Flag_Antipassback = 'Y')
		BEGIN
			SET @Id_CD_Motivo = 108 /*Ya ingresado. Antipassback*/
			EXEC CP_SCA_RegistrarAcceso_Rta 0, '', 'ADVER', @Foto, @Foto_Bin, @Id_Cliente, @Id_Cliente_Ref, @pTipoAcceso, @pTag, @pFecha, @pId_Controlador, @pId_Acceso, @Id_CD_Motivo, @pFlag_GrabaRegistro, @pFlag_Permite_Paso
		END
	
		IF(@Flag_Antipassback = 'E')
		BEGIN
			SET @Id_CD_Motivo = 109 /*No Registro Salida. Antipassback*/
			EXEC CP_SCA_RegistrarAcceso_Rta 0, '', 'ADVER', @Foto, @Foto_Bin, @Id_Cliente, @Id_Cliente_Ref, @pTipoAcceso, @pTag, @pFecha, @pId_Controlador, @pId_Acceso, @Id_CD_Motivo, @pFlag_GrabaRegistro, @pFlag_Permite_Paso
		END
	
		IF(@Flag_Antipassback = 'S')
		BEGIN
			SET @Id_CD_Motivo = 110 /*No Registro Entrada. Antipassback*/
			EXEC CP_SCA_RegistrarAcceso_Rta 0, '', 'ADVER', @Foto, @Foto_Bin, @Id_Cliente, @Id_Cliente_Ref, @pTipoAcceso, @pTag, @pFecha, @pId_Controlador, @pId_Acceso, @Id_CD_Motivo, @pFlag_GrabaRegistro, @pFlag_Permite_Paso
		END
		RETURN
	END
END
/*-----------------------------------------------------------------------------------FIN Valida AntiPassBack*/


/*-----------------------------------------------------------------------------------Valida Foto Grabada*/
IF(@Flag_Evento IN (0,1))
BEGIN
	EXEC dbo.CP_SCA_ValidarFoto @Id_Cliente, @pId_Acceso, @pFecha, @pTipoAcceso, @pFechaEvento, @Flag_ValidarFoto_Rta = @Flag_Foto_Validar OUTPUT

	PRINT 'Valido Foto Cliente: ' + CONVERT(VARCHAR(10), @Flag_Foto_Validar)

	IF(@Flag_Foto_Validar <> 1)
	BEGIN
		SET @Id_CD_Motivo = 111 /*No posee foto*/
		EXEC CP_SCA_RegistrarAcceso_Rta 0, '', 'ADVER', @Foto, @Foto_Bin, @Id_Cliente, @Id_Cliente_Ref, @pTipoAcceso, @pTag, @pFecha, @pId_Controlador, @pId_Acceso, @Id_CD_Motivo, @pFlag_GrabaRegistro, @pFlag_Permite_Paso
		RETURN
	END
END
/*-----------------------------------------------------------------------------------FIN Valida Foto Grabada*/


/*-----------------------------------------------------------------------------------Valida Turno (10/08/2020)*/
IF(@Flag_Evento IN (0))
BEGIN
	IF(@pFlag_Generacion_LB = 0) --02/11/2020 Solo valida turno si no esta generando una lista blanca (Simulacion de entrada)
	BEGIN
		IF(@pTipoAcceso = 'E') /*Solo se valida Turno si es Entrada*/
		BEGIN
			EXEC dbo.CP_SCA_ValidarTurno @Id_Cliente, @pId_Acceso, @pFecha, @pTipoAcceso, @pFechaEvento, @Flag_ValidarTurno_Rta = @Flag_Turno_Validar OUTPUT

			PRINT 'Valido Turno Cliente: ' + CONVERT(VARCHAR(10), @Flag_Turno_Validar)

			IF(@Flag_Turno_Validar <> 1)
			BEGIN
				SET @Id_CD_Motivo = 113 /*No posee un Turno*/
				EXEC CP_SCA_RegistrarAcceso_Rta 0, '', 'ADVER', @Foto, @Foto_Bin, @Id_Cliente, @Id_Cliente_Ref, @pTipoAcceso, @pTag, @pFecha, @pId_Controlador, @pId_Acceso, @Id_CD_Motivo, @pFlag_GrabaRegistro, @pFlag_Permite_Paso
				RETURN
			END
		END
	END
END
/*-----------------------------------------------------------------------------------FIN Valida Turno*/



-----------------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------
---------------------A partir de aca busco el porque habilito
-----------------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------
-----------------------------------------------------------------------------------------------------------------------------------



/*-----------------------------------------------------------------------------------Valida Clientes_Links (28/09/2020)*/
IF(@Flag_Evento IN (0))
BEGIN
	EXEC dbo.CP_SCA_ValidarClientes_Links @Id_Cliente, @pId_Acceso, @pFecha, @pTipoAcceso, @pFechaEvento, @Flag_ValidarClientes_Link_Rta = @Flag_Clientes_Link_Validar OUTPUT

	PRINT 'Valido Clientes_Link: ' + CONVERT(VARCHAR(10), @Flag_Clientes_Link_Validar)

	IF(@Flag_Clientes_Link_Validar = 1)
	BEGIN
		SET @Id_CD_Motivo = 212 /*Habilit. por QR*/
		EXEC CP_SCA_RegistrarAcceso_Rta 1, '', 'OBSER', @Foto, @Foto_Bin, @Id_Cliente, @Id_Cliente_Ref, @pTipoAcceso, @pTag, @pFecha, @pId_Controlador, @pId_Acceso, @Id_CD_Motivo, @pFlag_GrabaRegistro, @pFlag_Permite_Paso
		RETURN
	END
END
/*-----------------------------------------------------------------------------------FIN Valida Clientes_Links*/


/*-----------------------------------------------------------------------------------Valida por UCP*/
IF(@Flag_Evento IN (0,1))
BEGIN
	SET @Flag_ValidarUCP = (dbo.CF_SCA_ValidarUltCuotaPaga(@Id_Cliente, @pId_Acceso, @pFecha))
	IF(@Flag_ValidarUCP = 1)
	BEGIN
		PRINT 'Tipo de Habilitacion: ' + 'Habilitado. La Persona posee UCP al dia'
	
		SET @Id_CD_Motivo = 203 /*La Persona con UCP al dia*/
	
		EXEC CP_SCA_RegistrarAcceso_Rta 1,  '', 'OBSER', @Foto, @Foto_Bin, @Id_Cliente, @Id_Cliente_Ref, @pTipoAcceso, @pTag, @pFecha, @pId_Controlador, @pId_Acceso, @Id_CD_Motivo, @pFlag_GrabaRegistro, @pFlag_Permite_Paso
		RETURN
	END
END
/*-----------------------------------------------------------------------------------FIN Valida por UCP*/


/*-----------------------------------------------------------------------------------Valida Contratos Tipos de Habilitacion*/
IF(@Flag_Evento IN (0))
BEGIN
	SET @ValidarContratosTipos = (dbo.CF_SCA_ValidarContratosTipos(@Id_Cliente, @pId_Acceso, @pFecha))
	PRINT 'Valida Contratos Tipos de Habilitacion: ' + CONVERT(VARCHAR(10), @ValidarContratosTipos)

	IF(@ValidarContratosTipos <> 0)
	BEGIN
		SET @Id_CD_Motivo = 204 /*Habilit. por Tipo de Contrato*/
	
		SET @ContratoHabilitado_Descripcion = (SELECT RTRIM(LTRIM(CT.Descripcion)) FROM Contratos_Tipos CT, Contratos CO WHERE CT.Id_Tipo_Con = CO.Id_Tipo_Con AND Id_Contrato = @ValidarContratosTipos)
		PRINT 'Tipo de Contrato de Habilitacion: ' + @ContratoHabilitado_Descripcion

		EXEC CP_SCA_RegistrarAcceso_Rta 1,  @ContratoHabilitado_Descripcion, 'OBSER', @Foto, @Foto_Bin, @Id_Cliente, @Id_Cliente_Ref, @pTipoAcceso, @pTag, @pFecha, @pId_Controlador, @pId_Acceso, @Id_CD_Motivo, @pFlag_GrabaRegistro, @pFlag_Permite_Paso
		RETURN
	END
END
/*-----------------------------------------------------------------------------------FIN Valida Contratos Tipos de Habilitacion*/


/*-----------------------------------------------------------------------------------Valida Tipo de Categoria de Habilitacion*/
IF(@Flag_Evento IN (0,1))
BEGIN
	SET @ValidarTipo = (dbo.CF_SCA_ValidarTipo(@Id_Cliente, @pId_Acceso, @pFecha))
	PRINT 'Tipo de Cliente de Habilitacion: ' + CONVERT(VARCHAR(10), @ValidarTipo)

	IF(@ValidarTipo <> 0)
	BEGIN
		SET @Id_CD_Motivo = 205 /*Habilit. por Tipo de Cliente*/
	
		SET @Clientes_Tipos_Habil_Descripcion = (SELECT RTRIM(LTRIM(CT.Descripcion)) FROM Clientes_Tipos CT WHERE Id_Tipo_Cli = @ValidarTipo)
		PRINT 'Tipo de Cliente de Habilitacion: ' + @Clientes_Tipos_Habil_Descripcion

		EXEC CP_SCA_RegistrarAcceso_Rta 1, @Clientes_Tipos_Habil_Descripcion, 'OBSER', @Foto, @Foto_Bin, @Id_Cliente, @Id_Cliente_Ref, @pTipoAcceso, @pTag, @pFecha, @pId_Controlador, @pId_Acceso, @Id_CD_Motivo, @pFlag_GrabaRegistro, @pFlag_Permite_Paso
		RETURN
	END
END
/*-----------------------------------------------------------------------------------FIN Valida Tipo de Categoria de Habilitacion*/


/*----------------------------------------------------------------------------------Valida Producto de Venta*/
IF(@Flag_Evento IN (0))
BEGIN
	EXEC dbo.[CP_SCA_ValidarProducVta] @Id_Cliente, @pId_Acceso, @pFecha,0,0, @Id_Producto = @ValidarProdVta  OUTPUT

	PRINT 'Valida Producto de Venta: ' + @ValidarProdVta

	IF(@ValidarProdVta <> '')
	BEGIN
		SET @Id_CD_Motivo = 206 /*Habilit. por Produc. Comprado*/
	
		SET @Producto_Descripcion_Resumida = (SELECT ISNULL(Descripcion_Resumida, Id_Producto) FROM Productos WHERE Id_Producto = @ValidarProdVta)
		PRINT 'Producto de Venta: ' + @Producto_Descripcion_Resumida
	
		EXEC CP_SCA_RegistrarAcceso_Rta 1, @Producto_Descripcion_Resumida, 'OBSER', @Foto, @Foto_Bin, @Id_Cliente, @Id_Cliente_Ref, @pTipoAcceso, @pTag, @pFecha, @pId_Controlador, @pId_Acceso, @Id_CD_Motivo, @pFlag_GrabaRegistro, @pFlag_Permite_Paso
		RETURN
	END
END
/*----------------------------------------------------------------------------------FIN Valida Producto de Venta*/


/*----------------------------------------------------------------------------------Valida Producto de Venta Titular*/
IF(@Flag_Evento IN (0))
BEGIN
	IF (@Id_Cliente_Ref<>0)
	BEGIN
		EXEC dbo.[CP_SCA_ValidarProducVta] @Id_Cliente, @pId_Acceso, @pFecha,@Id_Cliente_Ref,0, @Id_Producto = @ValidarProdVta  OUTPUT

		SET @Id_CD_Motivo = 207 /*Habilit. por Produc. Comprado por Titular*/
	
		PRINT 'Valida Producto de Venta Titular: ' + @ValidarProdVta

		IF(@ValidarProdVta <> '')
		BEGIN
			SET @Producto_Descripcion_Resumida = (SELECT ISNULL(Descripcion_Resumida, Id_Producto) FROM Productos WHERE Id_Producto = @ValidarProdVta)
			PRINT 'Producto de Venta: ' + @Producto_Descripcion_Resumida
	
			EXEC CP_SCA_RegistrarAcceso_Rta 1, @Producto_Descripcion_Resumida, 'OBSER', @Foto, @Foto_Bin, @Id_Cliente, @Id_Cliente_Ref, @pTipoAcceso, @pTag, @pFecha, @pId_Controlador, @pId_Acceso, @Id_CD_Motivo, @pFlag_GrabaRegistro, @pFlag_Permite_Paso
			RETURN
		END
	END
END
/*----------------------------------------------------------------------------------FIN Valida Producto de Venta Titular*/


/*----------------------------------------------------------------------------------Valida Evento*/
IF(@Flag_Evento IN (1))
BEGIN
	--Agregado 29/06/2018
	SET @ValidarEvento = (dbo.CF_SCA_ValidarEvento(@Id_Cliente, @pId_Acceso, @pFecha))
	PRINT 'Tipo de Habilitacion Evento: ' + CONVERT(VARCHAR(10), @ValidarEvento)

	IF(@ValidarEvento <> 0)
	BEGIN
		SET @Id_CD_Motivo = 208 /*Habilit. por Evento*/
	
		SET @Clientes_Tipos_Habil_Evento = (SELECT RTRIM(LTRIM(Descripcion)) FROM Prod_Listas_Precios WHERE Id_Lista_Precio = @ValidarEvento)
		PRINT 'Tipo de Habilitacion Evento: ' + @Clientes_Tipos_Habil_Descripcion

		EXEC CP_SCA_RegistrarAcceso_Rta 1, @Clientes_Tipos_Habil_Evento, 'OBSER', @Foto, @Foto_Bin, @Id_Cliente, @Id_Cliente_Ref, @pTipoAcceso, @pTag, @pFecha, @pId_Controlador, @pId_Acceso, @Id_CD_Motivo, @pFlag_GrabaRegistro, @pFlag_Permite_Paso
		RETURN
	END
END
/*----------------------------------------------------------------------------------FIN Valida Evento*/


/*----------------------------------------------------------------------------------Valida Categoria por Horario*/
IF(@Flag_Evento IN (0))
BEGIN
	SET @ValidarTipo = (dbo.CF_SCA_ValidarCategHorario(@Id_Cliente, @pId_Acceso, @pFecha))
	PRINT 'Tipo de Cliente de Habilitacion: ' + CONVERT(VARCHAR(10), @ValidarTipo)

	IF(@ValidarTipo <> 0)
	BEGIN
		SET @Id_CD_Motivo = 209 /*Habilit. por Categoria por horario*/
	
		SET @Clientes_Tipos_Habil_Descripcion = (SELECT RTRIM(LTRIM(CT.Descripcion)) FROM Clientes_Tipos CT WHERE Id_Tipo_Cli = @ValidarTipo)
		PRINT 'Tipo de Cliente de Habilitacion: ' + @Clientes_Tipos_Habil_Descripcion

		EXEC CP_SCA_RegistrarAcceso_Rta 1, @Clientes_Tipos_Habil_Descripcion, 'OBSER', @Foto, @Foto_Bin, @Id_Cliente, @Id_Cliente_Ref, @pTipoAcceso, @pTag, @pFecha, @pId_Controlador, @pId_Acceso, @Id_CD_Motivo, @pFlag_GrabaRegistro, @pFlag_Permite_Paso
		RETURN
	END
END
/*----------------------------------------------------------------------------------FIN Valida Categoria por Horario*/


/*----------------------------------------------------------------------------------Valida Producto de Venta por horario*/
IF(@Flag_Evento IN (0))
BEGIN
	EXEC dbo.[CP_SCA_ValidarProducVta] @Id_Cliente, @pId_Acceso, @pFecha,0,1, @Id_Producto = @ValidarProdVta  OUTPUT

	PRINT 'Valida Producto de Venta: ' + @ValidarProdVta

	IF(@ValidarProdVta <> '')
	BEGIN
		SET @Id_CD_Motivo = 210 /*Habilit. por Produc. Comprado por horario*/
	
		SET @Producto_Descripcion_Resumida = (SELECT ISNULL(Descripcion_Resumida, Id_Producto) FROM Productos WHERE Id_Producto = @ValidarProdVta)
		PRINT 'Producto de Venta: ' + @Producto_Descripcion_Resumida
	
		EXEC CP_SCA_RegistrarAcceso_Rta 1, @Producto_Descripcion_Resumida, 'OBSER', @Foto, @Foto_Bin, @Id_Cliente, @Id_Cliente_Ref, @pTipoAcceso, @pTag, @pFecha, @pId_Controlador, @pId_Acceso, @Id_CD_Motivo, @pFlag_GrabaRegistro, @pFlag_Permite_Paso
		RETURN
	END
END
/*----------------------------------------------------------------------------------FIN*/


/*---------------------------------------------------------RECACHAZO SI NO ACEPTO ANTES---------*/

SET @Id_CD_Motivo = 112 /*No cumple ninguna condicin habilitante*/
EXEC CP_SCA_RegistrarAcceso_Rta 0, '', 'ADVER', @Foto, @Foto_Bin, @Id_Cliente, @Id_Cliente_Ref, @pTipoAcceso, @pTag, @pFecha, @pId_Controlador, @pId_Acceso, @Id_CD_Motivo, @pFlag_GrabaRegistro, @pFlag_Permite_Paso

PRINT 'FIN del Proceso: CP_SCA_RegistrarAcceso'
RETURN

END

/*
EXEC dbo.CP_SCA_RegistrarAcceso	1,							--@pId_Controlador: Id_ Molinete
								'S',						--@pTipoAcceso: E: Entrada / S:Salida
								'2020-08-18T12:16:00',		--@pFecha: Fecha a comparar
								'19000101',					--@pFechaEvento: Fecha del Evento a comparar. Si no es un evento ingresar 19000101
								'0025545736',				--@pTag: Credencial MiFare / Wiegand
								0,							--@pDoc: Documento
								'',							--@pHue: Huella Dactilar
								'',							--@pCba: Codigo de Barra
								'',							--@pDma: Data Matrix
								1,							--@pFlag_GrabaRegistro(NULL): 23/09/2019. 1(default): Graba Registro. 0: No graba el registro
								0,							--@pFlag_Permite_Paso(NULL):  05/02/2020. 1: Si el resultado es habilitado permite que la persona pase 1 vez mas la proxima vez
								0							--@pFlag_Generacion_LB(NULL): 02/11/2020. 1: Si la llamada la esta haciendo para generar Listas Blancas, en esos casos hay validaciones que no hace como Validacion de Turnos

*/
